<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('name', 'phone', 'address', 'email', 'bank_id', 'monthly_salary_amount', 'monthly_commitments_amount', 'Insurance_value', 'expected_funding', 'is_registerd_by_marketer', 'ability_to_notify');

    public function notifications()
    {
        return $this->morphMany('App\Models\Notification', '"notificationable"');
    }

    public function transactions()
    {
        return $this->hasMany('App\Models\Transaction');
    }

    public function marketer()
    {
        return $this->belongsTo('App\Models\Marketer');
    }

}